CREATE OR REPLACE FUNCTION ADDCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'pdv_vd_nfce' 
                  and column_name='dt_envio'
	) THEN
           RAISE NOTICE 'Coluna DT_ENVIO na tabela PDV_VD_NFCE ja existe!' ;
    ELSE
		ALTER TABLE PDV_VD_NFCE ADD DT_ENVIO timestamp null;
        RAISE NOTICE 'Coluna "DT_ENVIO" criada com sucesso!';
    END IF; 
   
   IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'pdv_vd_nfce' 
                  and column_name='qtd_envio'
	) THEN
           RAISE NOTICE 'Coluna QTD_ENVIO na tabela PDV_VD_NFCE ja existe!' ;
    ELSE
		ALTER TABLE PDV_VD_NFCE ADD QTD_ENVIO int null;
        RAISE NOTICE 'Coluna "DT_ENVIO" criada com sucesso!';
    END IF; 
    
END; 


$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION ADDCOLUMN()  OWNER TO POSTGRES;
SELECT ADDCOLUMN();
DROP FUNCTION ADDCOLUMN();



